/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.utils.apihandlers.plant.TreeCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinitySaw
extends ItemInfinity {
    public static LoadingCache<Pair<Level, BlockPos>, TreeCache> SAW_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Pair<Level, BlockPos>, TreeCache>(){

        public TreeCache load(Pair<Level, BlockPos> key) throws Exception {
            TreeCache cache = new TreeCache((Level)key.getLeft(), (BlockPos)key.getRight());
            cache.scanForTreeBlockSection();
            return cache;
        }
    });
    public static int POWER_CONSUMPTION = 10000;
    public static int FUEL_CONSUMPTION = 3;

    public ItemInfinitySaw(CreativeModeTab group) {
        super("infinity_saw", group, new Item.Properties().m_41487_(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return Items.f_42391_.canApplyAtEnchantingTable(new ItemStack((ItemLike)Items.f_42391_), enchantment);
    }

    public boolean m_8096_(BlockState blockIn) {
        return Items.f_42391_.m_8096_(blockIn);
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof Player && BlockUtils.isLog(worldIn, pos)) {
            try {
                TreeCache cache = (TreeCache)SAW_CACHE.get((Object)Pair.of((Object)worldIn, (Object)pos));
                if (cache != null) {
                    ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                    InfinityTier currentTier = ItemInfinitySaw.getSelectedTier(stack);
                    int operations = this.getBlocksAmount(currentTier.getRadius());
                    for (int i = 0; i < operations; ++i) {
                        if (cache.getWoodCache().isEmpty() && cache.getLeavesCache().isEmpty()) {
                            SAW_CACHE.invalidate((Object)Pair.of((Object)worldIn, (Object)pos));
                            break;
                        }
                        if (!this.enoughFuel(stack)) break;
                        if (!cache.getLeavesCache().isEmpty()) {
                            itemStacks.addAll(cache.chop(cache.getLeavesCache(), false));
                        } else {
                            itemStacks.addAll(cache.chop(cache.getWoodCache(), false));
                        }
                        this.consumeFuel(stack);
                    }
                    itemStacks.forEach(itemStack -> ItemHandlerHelper.giveItemToPlayer((Player)((Player)entityLiving), (ItemStack)itemStack));
                    return false;
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private int getBlocksAmount(int radius) {
        return (radius * 2 + 1) * (radius * 2 + 1);
    }

    @Override
    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        new DissolutionChamberRecipe(this.getRegistryName(), new Ingredient.Value[]{new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41959_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42390_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42391_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42391_)), new Ingredient.ItemValue(new ItemStack((ItemLike)ModuleCore.RANGE_ADDONS[11].get())), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2000), 400, new ItemStack((ItemLike)this), FluidStack.EMPTY);
    }
}

